local require = GLOBAL.require
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local ACTIONS = GLOBAL.ACTIONS
local Action = GLOBAL.Action
local TECH = GLOBAL.TECH
local cooking = require("cooking")

--rezecib
local function HealthPostInit(self)
	local OldRecalculatePenalty = self.RecalculatePenalty
	local function RecalculatePenalty(self, forceupdatewidget)
		local mult = GLOBAL.TUNING.REVIVE_HEALTH_PENALTY_AS_MULTIPLE_OF_EFFIGY
		mult = mult * GLOBAL.TUNING.EFFIGY_HEALTH_PENALTY
		local maxrevives = (self.maxhealth - 30)/mult
		if self.numrevives > maxrevives then
			self.numrevives = maxrevives
		end
		OldRecalculatePenalty(self, forceupdatewidget)
	end
	self.RecalculatePenalty = RecalculatePenalty
end

AddComponentPostInit('health', HealthPostInit)

STRINGS.NAMES.DIB = "Dib"
STRINGS.CHARACTER_TITLES.dib = "Paranormal Investigator"
STRINGS.CHARACTER_NAMES.dib = "Dib"
STRINGS.CHARACTER_DESCRIPTIONS.dib = "*weak\n*strong in mind\n*resurrects ghosts"
STRINGS.CHARACTER_QUOTES.dib = "\"That's just dumb.\""
STRINGS.CHARACTERS.DIB = require "speech_dib"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.dib = "That is a big head."
STRINGS.CHARACTERS.DIB.DESCRIBE.DIB = {"A clone?", "Me!"}
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.DIB = ("Poor boy.")
STRINGS.CHARACTERS.WAXWELL.DESCRIBE.DIB = ("How did you get here?")
STRINGS.CHARACTERS.WOODIE.DESCRIBE.DIB = ("Look at his head, Lucy.")
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.DIB = ("Little boy.")
STRINGS.CHARACTERS.WENDY.DESCRIBE.DIB = ("I see a fire in his eyes.")
STRINGS.CHARACTERS.WX78.DESCRIBE.DIB = ("Men.")


STRINGS.CHARACTERS.DIB.ANNOUNCE_NOSANITY = "I AM Dib!"	

PrefabFiles = {
	"dib",
}

Assets = {
	Asset( "IMAGE", "images/saveslot_portraits/dib.tex"),
	Asset( "ATLAS", "images/saveslot_portraits/dib.xml"),
	
	Asset( "IMAGE", "images/selectscreen_portraits/dib.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/dib.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/dib_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/dib_silho.xml" ),

    Asset( "IMAGE", "bigportraits/dib.tex" ),
    Asset( "ATLAS", "bigportraits/dib.xml" ),

    Asset( "IMAGE", "minimap/dib.tex" ),
    Asset( "ATLAS", "minimap/dib.xml" ),
	
	Asset("SOUNDPACKAGE", "sound/dib.fev"),
    Asset("SOUND", "sound/dib_bank03.fsb"),
		
	Asset( "IMAGE", "images/avatars/avatar_dib.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_dib.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_dib.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_dib.xml" ),
	}

GetPlayer = GLOBAL.GetPlayer
AddMinimapAtlas("minimap/dib.xml")



RemapSoundEvent( "dontstarve/characters/dib/death_voice", "dib/characters/dib/death_voice" )
RemapSoundEvent( "dontstarve/characters/dib/hurt", "dib/characters/dib/hurt" )
RemapSoundEvent( "dontstarve/characters/dib/talk_LP", "dib/characters/dib/talk_LP" )


GLOBAL.STRINGS.CHARACTERS.Dib = GLOBAL.require("speech_dib")

AddModCharacter("dib")
table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "dib")

for k, v in pairs(CHARACTERLIST) do
    if v.prefab ~= "wilson" then
        AddPrefabPostInit(v, ModCharacterInit)
    end
end


for k,v  in pairs(GLOBAL.MODCHARACTERLIST) do
    AddPrefabPostInit(v, ModCharacterInit)
end